# 第一个完整的C#程序

前一章的习题里我们已经使用 C#10.0 的方式，写了一些C#全局代码。在更早的版本里，则需要编写完整的C#代码。例如：

```csharp
using System;
using System.Collections.Generic;
using System.Linq;

namespace Program{
    public class Program{
        public static void Main(string[] args){
            // C# 代码
        }
    }
}
```

.NET 6 下使用命令创建一个C#程序：

```bash
dotnet new console --output sample
```

在 `sample/Program.cs` 里编写程序，然后执行下面的命令运行：

```bash
dotnet run --project sample
```

在 C# 10.0 里以下代码不能正确运行的是？

## 答案

```csharp
WriteLine("Hello, World!");
```

## 选项

### 完整的C#代码

```csharp
using System;
using System.Collections.Generic;
using System.Linq;

namespace Program{
    public class Program{
        public static void Main(string[] args){
            Console.WriteLine("Hello, World!");
        }
    }
}
```

### 不使用using

```csharp
public class Program{
    public static void Main(string[] args){
        Console.WriteLine("Hello, World!");
    }
}
```

### 全局代码

```csharp
Console.WriteLine("Hello, World!");
```
